/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByGender;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidBodyType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Profession;

public class HumanoidEntityAssetsByBodyType {
    private Map<HumanoidBodyType, HumanoidEntityAssetsByGender> bodyTypeMap = new EnumMap<HumanoidBodyType, HumanoidEntityAssetsByGender>(HumanoidBodyType.class);

    public HumanoidEntityAssetsByBodyType() {
        for (HumanoidBodyType type : HumanoidBodyType.values()) {
            this.bodyTypeMap.put(type, new HumanoidEntityAssetsByGender());
        }
    }

    public void add(HumanoidEntityAsset asset) {
        HumanoidBodyType bodyType = asset.getBodyType();
        if (bodyType == null) {
            for (HumanoidEntityAssetsByGender humanoidEntityAssetsByGender : this.bodyTypeMap.values()) {
                humanoidEntityAssetsByGender.add(asset);
            }
        } else {
            this.bodyTypeMap.get((Object)bodyType).add(asset);
            this.bodyTypeMap.get((Object)HumanoidBodyType.ANY).add(asset);
        }
    }

    public HumanoidEntityAsset get(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        HumanoidBodyType bodyType = attributes.getBodyType();
        if (bodyType == null) {
            bodyType = HumanoidBodyType.ANY;
        }
        return this.bodyTypeMap.get((Object)bodyType).get(attributes, primaryProfession);
    }

    public List<HumanoidEntityAsset> getAll(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        HumanoidBodyType bodyType = attributes.getBodyType();
        if (bodyType == null) {
            bodyType = HumanoidBodyType.ANY;
        }
        return this.bodyTypeMap.get((Object)bodyType).getAll(attributes, primaryProfession);
    }
}

